<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'image', 'position', 'is_active', 'specialty_id');

    public function specialties()
    {
        return $this->belongsToMany('App\Models\Specialty', 'doctor_id', 'specialty_id');
    }

}